<?php
use App\Controllers\Auth\AuthController;
use App\Controllers\Auth\PasswordController;
use App\Controllers\CPEmailController;
use App\Controllers\System\ProfileController;
use App\Controllers\System\SettingsController;
use App\Controllers\System\UsersController;
use App\Middleware\AuthMiddleware;
use App\Middleware\GuestMiddleware;

$app->get('/', AuthController::class .':createLogin')->setName('index');

$app->group('', function ($route) {
    $route->get('/login', AuthController::class . ':createLogin')->setName('login');
    $route->post('/login', AuthController::class . ':login');

    $route->get('/verify-email', AuthController::class.':verifyEmail')->setName('verify.email');
    $route->get('/verify-email-resend',AuthController::class.':verifyEmailResend')->setName('verify.email.resend');

    $route->get('/forgot-password', PasswordController::class . ':createForgotPassword')->setName('forgot.password');
    $route->post('/forgot-password', PasswordController::class . ':forgotPassword');
    $route->get('/reset-password', PasswordController::class.':resetPassword')->setName('reset.password');
    $route->get('/update-password', PasswordController::class.':createUpdatePassword')->setName('update.password');
    $route->post('/update-password', PasswordController::class.':updatePassword');

})->add(new GuestMiddleware($container));


$app->group('', function ($route) {
    $route->get('/dashboard', UsersController::class .':index')->setName('home');
    $route->get('/logout', AuthController::class . ':logout')->setName('logout');
    //profile
    $route->get('/profile', ProfileController::class . ':index')->setName('profile');
    $route->post('/profile', ProfileController::class . ':update');
    $route->get('/change-password', ProfileController::class . ':createChangePassword')->setName('change.password');
    $route->post('/change-password', ProfileController::class . ':changePassword');
    $route->get('/user/mail', ProfileController::class . ':hmail')->setName('hmail');
    $route->get('/user/mail-auth', ProfileController::class . ':hmailAuth')->setName('hmail.auth');
    $route->get('/settings', SettingsController::class . ':index')->setName('settings');
    $route->post('/settings', SettingsController::class . ':update');
})->add(new AuthMiddleware($container));


$app->group('/admin', function ($route) {
    //users
    $route->get('/users', UsersController::class .':index')->setName('user.index');
    $route->get('/users/datatable', UsersController::class .':datatable')->setName('user.datatable');
    $route->get('/users/show/{id}', UsersController::class .':show')->setName('user.show');
    $route->get('/users/create', UsersController::class .':create')->setName('user.create');
    $route->post('/users/store', UsersController::class .':store')->setName('user.store');
    $route->get('/users/edit/{id}', UsersController::class .':edit')->setName('user.edit');
    $route->post('/users/update', UsersController::class .':update')->setName('user.update');
    $route->post('/users/destroy/{id}', UsersController::class .':destroy')->setName('user.destroy');
    $route->get('/users/password/{id}', UsersController::class .':createPassword')->setName('user.password');
    $route->post('/users/password', UsersController::class .':password')->setName('user.password.store');
})->add(new AuthMiddleware($container));

$app->group('/cp/email', function ($route) {
    $route->get('/list', CPEmailController::class .':index')->setName('email.index');
    $route->get('/create', CPEmailController::class .':create')->setName('email.create');
    $route->post('/store', CPEmailController::class .':store')->setName('email.store');
    $route->post('/update-quota', CPEmailController::class .':updateQuota')->setName('email.update.quota');
    $route->post('/update-password', CPEmailController::class .':updatePassword')->setName('email.update.password');
    $route->post('/destroy/{email}', CPEmailController::class .':deleteEmail')->setName('email.destroy');
    $route->get('/create/forward/{email}', CPEmailController::class .':createForward')->setName('email.forward.create');
    $route->post('/manage/forward', CPEmailController::class .':manageForwarding')->setName('email.forward');
    $route->get('/create/auto-responder/{email}', CPEmailController::class .':createAutoResponder')->setName('email.autoresponder.create');
    $route->post('/manage/auto-responder', CPEmailController::class .':manageAutoResponder')->setName('email.autoresponder.manage');
})->add(new AuthMiddleware($container));


