<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Initial Setup | Cpanel Settings</title>
    <link href="../public/assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="../public/assets/css/bootstrap-icons.css" rel="stylesheet">
    <link href="../public/assets/css/auth.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5 mb-5">
    <form action="install.php" name="install" method="post">

        <div class="row d-flex align-items-center justify-content-center">
            <div class="col-md-5">
                <?php if(isset($_SESSION['installMsg']) and $_SESSION['installMsg']!=''){ ?>
                <div class="alert alert-danger"><?php echo $_SESSION['installMsg']; unset($_SESSION['installMsg']); ?></div>
                <?php } ?>
                <div class="card px-5 py-5 shadow-none">
                    <h5 class="mt-3">Cpanel Settings</h5>

                    <div class="form-input">
                        <label for="CPANEL_DOMAIN" class="form-label">Domain Name</label>
                        <input type="text" name="CPANEL_DOMAIN" id="CPANEL_DOMAIN" placeholder="e.g: example.com" class="form-control" required>
                    </div>

                    <div class="form-input">
                        <label for="CPANEL_USERNAME" class="form-label ">Username</label>
                        <input type="text" id="CPANEL_USERNAME" name="CPANEL_USERNAME" placeholder="Enter cpanel username" class="form-control" required>
                    </div>

                    <div class="form-input">
                        <label for="CPANEL_PASSWORD" class="form-label">Password</label>
                        <input type="text" id="CPANEL_PASSWORD" name="CPANEL_PASSWORD" placeholder="Enter cpanel password" class="form-control" required>
                    </div>

                    <button type="submit" class="btn btn-primary mt-4 signup">Install</button>

                </div>
            </div>
        </div>
    </form>
</div>
<script src="../public/assets/js/bootstrap.bundle.min.js"></script>
</body>
</html>
