<?php
use Illuminate\Database\Capsule\Manager;

$capsule = new Manager;

$config = config('connections');
// SQLite Connection
if (config('default') == 'sqlite') {
    $capsule->addConnection($config['sqlite']);
    // Raw PDO Connection
    $pdo = new \PDO("sqlite:".__DIR__."/../database/database.sqlite");
}
// MySQL Connection as default
else{
    $capsule->addConnection($config['mysql']);
    // Raw PDO Connection
    $pdo = new \PDO($config['mysql']['driver'].':dbname='.$config['mysql']['database'].';host='.$config['mysql']['host'].';charset='.$config['mysql']['charset'].'', $config['mysql']['username'], $config['mysql']['password']);
}

$capsule->setAsGlobal();
$capsule->bootEloquent();
